#pragma once

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/loader.h>
#include <mapreduce/yt/interface/client.h>
#include <util/generic/string.h>

namespace maps::mrc::house_number_pipeline {

void calculateGroundTruthStatistic(
    NYT::IClientPtr& client,
    const TString& inputYTPath);

struct Statistic {
    size_t truePositives;
    size_t falsePositives;
    size_t falseNegatives;
    Statistic& operator+=(const Statistic& a){
      this->truePositives += a.truePositives;
      this->falsePositives += a.falsePositives;
      this->falseNegatives += a.falseNegatives;
      return *this;
    }
};

void detectHouseNumbers(
    NYT::IClientPtr& client,
    const TString& inputYTPath,
    const TString& outputYTTable,
    bool filterCars,
    bool recognizeNumbers,
    bool useGpu);

Statistic calculateDetectorRecognizerStatistic(
    NYT::IClientPtr& client,
    const TString& testYTTable,
    double minConfidenceDetector,
    double minConfidenceRecognizer,
    double iouThreshold,
    bool useRecognizedNumber,
    bool skipSymbolsUnknownByRecognizer);

void calculateDetectorRecognizerStatisticOnGrid(
    NYT::IClientPtr& client,
    const TString& testYTTable,
    double iouThreshold,
    bool useRecognizedNumber,
    bool skipSymbolsUnknownByRecognizer,
    const std::string& outputPath);

void recognizeHouseNumbers(
    NYT::IClientPtr& client,
    const TString& inputYTPath,
    const TString& outputYTTable,
    bool useGpu);

Statistic calculateRecognizerStatistic(
    NYT::IClientPtr& client,
    const TString& testYTTable,
    double minConfidence,
    bool skipSymbolsUnknownByRecognizer);

void searchAddressPoints(
    const maps::wiki::common::ExtendedXmlDoc& wikiConfig,
    maps::wiki::revision::DBID commitId,
    NYT::IClientPtr& client,
    const TString& detectedYTTable,
    const TString& addressPointsYTTable,
    bool skipSymbolsUnknownByRecognizer,
    const TString& objectsColumnName,
    const TString& objectNumberItemName,
    bool removeObjectsAddressPointFromMap,
    int threadsCount);

Statistic calculateAddressPointsStatistic(
    NYT::IClientPtr& client,
    const TString& testYTTable,
    double minConfidenceDetector,
    double minConfidenceRecognizer,
    double minConfidenceAddrPoint,
    bool skipSymbolsUnknownByRecognizer);

Statistic calculateHypothesesStatistic(
    NYT::IClientPtr& client,
    const TString& testYTTable,
    double minConfidenceDetector,
    double minConfidenceRecognizer,
    double minConfidenceAddrPoint,
    bool skipSymbolsUnknownByRecognizer,
    bool removeObjectsAddressPointFromMap);

void calculateHypothesesStatisticOnGrid(
    NYT::IClientPtr& client,
    const TString& testYTTable,
    bool skipSymbolsUnknownByRecognizer,
    bool removeObjectsAddressPointFromMap,
    const std::string& outputPath);

void exportDetectorResults(
    NYT::IClientPtr& client,
    const TString& detectorResultTable,
    double minConfidenceDetector,
    double minConfidenceRecognizer,
    const std::string& outputDetectorResultsPath);

} //namespace maps::mrc::house_number_pipeline

