#include "camera_angle.h"
#include "ground_truth_feature.h"

#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/io.h>
#include <maps/wikimap/mapspro/services/mrc/libs/camera/include/camera.h>
#include <maps/libs/geolib/include/direction.h>

#include <maps/libs/log8/include/log8.h>
#include <mapreduce/yt/interface/client.h>

namespace maps::mrc::opensfm_experiment {

namespace {

class RefineCameraHeadingsWorker: public yt::Mapper {
    void Do(yt::Reader* reader, yt::Writer* writer) override;
};

REGISTER_MAPPER(RefineCameraHeadingsWorker);

Camera initCamera(const NYT::TNode& row) {
    auto feature = deserialize(row);
    static const cv::Mat distortion = cv::Mat::zeros(5, 1, CV_64F);

    CameraParameters parameters {feature.intrinsics, distortion};
    Camera camera;
    camera.resetParameters(parameters, feature.image.size());

    return camera;
}

void RefineCameraHeadingsWorker::Do(yt::Reader* reader, yt::Writer* writer) {
    if (not reader->IsValid()) {
        return;
    }
    auto camera = initCamera(reader->GetRow());

    for (; reader->IsValid(); reader->Next()) {
        auto row = reader->GetRow();
        auto featureWithImage = deserialize(row);

        camera.estimateAngle(featureWithImage.image);
        auto refinement = maps::geolib3::Direction2(camera.angle());
        auto oldDirection = maps::geolib3::Direction2(featureWithImage.feature.heading());

        auto newDirection = oldDirection + refinement;

        featureWithImage.feature.setHeading(newDirection.heading());
        writer->AddRow(serialize(featureWithImage));
    }
}

} // namespace

void refineCameraHeadings(NYT::IClientBase& client, const TString& input, const TString& output) {
    INFO() << "Running headings refinement";
    client.Map(
        NYT::TMapOperationSpec()
            .AddInput<NYT::TNode>(input)
            .AddOutput<NYT::TNode>(output)
            .JobCount(1),
        new RefineCameraHeadingsWorker(),
        NYT::TOperationOptions()
    );
}

} // namespace maps::mrc::opensfm_experiment
