#pragma once

#include <maps/libs/geolib/include/heading.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>

#include <mapreduce/yt/interface/client.h>
#include <opencv2/opencv.hpp>

namespace maps::mrc::opensfm_experiment {

class GroundTruthFeature {
public:
    GroundTruthFeature(db::Feature feature) : feature(feature) {};

    db::Feature feature;
    geolib3::Point2 truePos;
    geolib3::Heading trueHeading;
    cv::Mat image;
    cv::Mat mask;
    cv::Mat intrinsics;
};

using GroundTruthFeatures = std::vector<GroundTruthFeature>;

NYT::TNode serialize(const GroundTruthFeature& value);

GroundTruthFeature deserialize(const NYT::TNode& node);

}
