#include "segmentation.h"
#include "ground_truth_feature.h"

#include <maps/wikimap/mapspro/services/mrc/libs/carsegm/include/carsegm.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/yt/include/io.h>

#include <util/generic/string.h>
#include <util/generic/size_literals.h>
#include <mapreduce/yt/interface/client.h>


namespace maps::mrc::opensfm_experiment {

namespace {

class CarSegmentatorWorker: public yt::Mapper {
    void Do(yt::Reader* reader, yt::Writer* writer) override;
};

void CarSegmentatorWorker::Do(yt::Reader* reader, yt::Writer* writer) {
    maps::mrc::carsegm::CarSegmentator segmentator;

    for (; reader->IsValid(); reader->Next()) {
        auto row = deserialize(reader->GetRow());

        if (row.image.empty()) {
            continue;
        }

        writer->AddRow(serialize(row));
    }
}

REGISTER_MAPPER(CarSegmentatorWorker);

} // namespace

void segmentCars(
        NYT::IClientBase& client,
        const TString& input,
        const TString& output)
{
    auto jobSpec = yt::baseGpuWorkerSpec()
        ("cpu_limit", 1)
        ("gpu_limit", 1)
        ("memory_limit", 4_GB);

    auto operationSpec = yt::baseGpuOperationSpec("Cars segmentation", yt::PoolType::AdHoc)
        ("mapper", jobSpec);

    client.Map(
        NYT::TMapOperationSpec()
            .AddInput<NYT::TNode>(input)
            .AddOutput<NYT::TNode>(output)
            .JobCount(5),
        new CarSegmentatorWorker(),
        NYT::TOperationOptions().Spec(operationSpec)
    );
}

} // namespace maps::mrc::opensfm_experiment
