#include "tools.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <exception>

int main(int argc, char** argv) try {
    maps::cmdline::Parser parser;
    auto config = parser.string("config").help("path to configuration");
    auto batchSize = parser.num("batch-size").defaultValue(500);
    parser.parse(argc, argv);

    INFO() << "generator started";
    auto cfg = maps::mrc::common::templateConfigFromCmdPath(configPath);
    auto pool = cfg.makePoolHolder();
    auto mds = cfg.makeMdsClient();
    maps::mrc::photo::fillSizes(pool.pool(), mds, batchSize);
    INFO() << "generator successfully finished";
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << "generator failed: " << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << "generator failed: " << e.what();
    return EXIT_FAILURE;
}
