#pragma once

#include <yandex/maps/coverage5/coverage.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/polygon.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>

#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <string>

namespace maps::mrc {

class GeoIdProvider {
public:
    GeoIdProvider(const std::string& geoIdPath)
        : coverage_(geoIdPath)
        , layer_(coverage_["geoid"])
    {}

    maps::geolib3::MultiPolygon2 geomById(db::TId geoId) const
    {
        return layer_.getRegion(geoId).geoms();
    }

private:
    maps::coverage5::Coverage coverage_;
    const maps::coverage5::Layer& layer_;
};

geolib3::MultiPolygon2
combine(const std::vector<geolib3::MultiPolygon2>& multipolygons)
{
    std::vector<geolib3::Polygon2> allPolygons;

    for (const auto& mp : multipolygons) {
        for (size_t i = 0; i < mp.polygonsNumber(); ++i) {
            allPolygons.push_back(mp.polygonAt(i));
        }
    }

    return geolib3::MultiPolygon2(allPolygons);
}

} // maps::mrc
