#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>

#include <maps/libs/geolib/include/multipolygon.h>

#include <string>
#include <optional>

namespace maps::mrc::signs_dumper {


struct FilterOptions {
    geolib3::MultiPolygon2 geodeticBoundary;
    std::optional<chrono::TimePoint> startTime;
    std::optional<chrono::TimePoint> endTime;
    std::optional<std::string> sourceId;
};

geolib3::MultiPolygon2 loadAdGeom(const std::string& ytTable, long long adId);

void run(common::Config&,
         const FilterOptions& filterOptions,
         const std::string& outDir);

}  // namespace maps::mrc::signs_dumper
