#pragma once
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/ugc.h>

#include <maps/libs/http/include/http.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>

#include <boost/range/iterator_range.hpp>

#include <ostream>
#include <vector>

namespace maps {
namespace mrc {
namespace tasks_analyzer {

geolib3::PolylinesVector makeSortedPolylines(const db::ugc::Targets& targets);

geolib3::PointsVector
makeRouteViaPointsForTaskTargets(const geolib3::PolylinesVector& polylines);

template <typename Cont>
std::vector<boost::iterator_range<typename Cont::const_iterator>>
splitToBatches(const Cont& cont,
               std::ptrdiff_t requestedBatchSize,
               std::ptrdiff_t overlap)
{
    ASSERT(0 <= overlap && overlap < requestedBatchSize);
    using Iterator = typename Cont::const_iterator;
    using Batch = boost::iterator_range<Iterator>;

    std::vector<Batch> batches;
    batches.reserve(cont.size() / (requestedBatchSize - overlap)
                    + cont.size() % (requestedBatchSize - overlap));
    Iterator it = cont.cbegin();
    while (it != cont.cend()) {
        const auto elementsLeft = std::distance(it, cont.cend());
        auto thisBatchSize = std::min(requestedBatchSize, elementsLeft);
        if (thisBatchSize <= overlap)
            break;

        batches.emplace_back(it, it + thisBatchSize);
        std::advance(it, requestedBatchSize - overlap);
    }
    return batches;
}

std::string makeRouteRequest(http::Client& client,
                             const std::string& endpoint,
                             boost::iterator_range<geolib3::PointsVector::const_iterator> range);

geolib3::PolylinesVector parseRouteResponse(const std::string& routeResponse);


double calcRouteRatio(const db::ugc::Targets& taskTargets,
                     const geolib3::PolylinesVector& routes);


geolib3::Polyline2 tryShiftGeom(const geolib3::Polyline2& polyline,
                                double shiftMeters);

void savePolylinesToFile(const geolib3::PolylinesVector& polylines,
                         std::ostream& out,
                         double shiftMeters,
                         size_t from = 0,
                         size_t points = 0);

// true if route fragment is on plan
std::vector<std::pair<geolib3::Polyline2, bool>>
compareRoutes(const geolib3::PolylinesVector& plannedRoute,
                const geolib3::PolylinesVector& route);

void saveRoutesComparison(
    const std::vector<std::pair<geolib3::Polyline2, bool>>& routesComparison,
    std::ostream& out);


void checkViaPointsPassingOrder(
        geolib3::PointsVector& viaPoints,
        std::ostream& out,
        geolib3::PolylinesVector& routes);


void saveViaPoints(geolib3::PointsVector& viaPoints, std::ostream& out, size_t limit = 0);


struct ViaPointsPassingInfo{
    geolib3::Point2 from;
    geolib3::Point2 to;

    geolib3::Polyline2 plannedRoute;
    geolib3::Polyline2 actualRoute;
};


struct CheckResult{
    std::vector<ViaPointsPassingInfo> passingInfos;
    std::vector<geolib3::Point2> missingPoints;
};


CheckResult
checkViaPointsPassingOrder(geolib3::Polyline2 plannedRoute,
                           geolib3::Polyline2 actualRoute,
                           const geolib3::PointsVector& viaPoints);

void
saveViaPointsCheck(const CheckResult& viaPointsCheck,
                   const std::string& evFilePrefix);


void formatInEasyview(std::ostream& out, const geolib3::Point2& point, const std::string& label=std::string());

void formatInEasyview(std::ostream& out, const geolib3::Polyline2& polyline, const std::string& label=std::string());


}}} // namespace maps::mrc::tasks_analyzer

