import tensorflow as tf
import numpy as np
import params
import cv2

graph_path = 'model.gdef'
with tf.gfile.FastGFile(graph_path, 'rb') as f:
	graph_def = tf.GraphDef()
	graph_def.ParseFromString(f.read())
	_ = tf.import_graph_def(graph_def, name='')

image = cv2.imread('image.jpg')

with tf.Session() as sess:
	class_names = sess.run(sess.graph.get_tensor_by_name('class_names:0'))

	softmax = sess.graph.get_tensor_by_name('inference_softmax:0')
	argmax  = tf.argmax(softmax, 1)

	resize_image = cv2.resize(image, (params.IMAGE_SIZE, params.IMAGE_SIZE))

        net_input = np.reshape(resize_image, (1, params.IMAGE_SIZE, params.IMAGE_SIZE, params.IMAGE_CHNS))

	softmax_out, argmax_out = sess.run([softmax, argmax], {'inference_input:0': net_input})

	print 'Class: ', class_names[argmax_out], ', probability: ', softmax_out[0][argmax_out]
