import os.path
from tsclasses.priority_1 import POS_CLASSES_FILES
from tsclasses.priority_1 import INVALID_CLASSES_FILES

IMAGE_CHNS   = 3
IMAGE_SIZE   = 32
TRAIN_FOLDER = os.path.abspath('./data_files/train/')
TEST_FOLDER  = os.path.abspath('./data_files/eval/')

USE_NEGATIVES = True
NEGATIVE_FILE = 'negatives.dat'
TRY_NEG_PER_IMAGE = 500
NEGS_LIST_FILEPATH = os.path.abspath('./data_files/negatives/neg.txt')

USE_INVALID = True

OUT_FOLDER   = os.path.abspath('./model-data/')

POS_CLASSES_CNT  = len(POS_CLASSES_FILES)
INVALID_CLASSES_CNT = len(INVALID_CLASSES_FILES)

OUT_CLASSES_CNT  = POS_CLASSES_CNT + (INVALID_CLASSES_CNT if USE_INVALID else 0) + (1 if USE_NEGATIVES else 0)

NEG_CLASS_IDX = (OUT_CLASSES_CNT - 1) if USE_NEGATIVES else -1
HARD_NEG_SEARCH = False
HARD_NEG_THRESHOLD = 0.5            # threshold of softmax from network for select hard network
NEGATIVE_EVAL_LOSS_THR = 0.001      # threshold of average loss of negative in eval, then loss is smaller
                                    # than the threshold algorithms start to update negatives by searching
                                    # hard negatives

CL_PER_BATCH = 64
NEG_PER_BATCH = 48 * CL_PER_BATCH
INVALID_PER_BATCH = 2 * CL_PER_BATCH
BATCH_SIZE   = CL_PER_BATCH * POS_CLASSES_CNT + (INVALID_PER_BATCH * INVALID_CLASSES_CNT if USE_INVALID else 0) + (NEG_PER_BATCH if USE_NEGATIVES else 0)
EPOCH_MAX    = 70

OPTIMIZER = 'AdamOptimizer'

LOSS_FILE_DUMP = os.path.abspath('./model_loss.log')

LR_BASE         = 0.0001
LR_DECAY_EPOCH  = 50
LR_DECAY_RATE   = 0.1

EPOCH_START     = 0
SAVE_EVERY_EPOCHES = 10
