def inters_area(bbox1, bbox2):
    """Calculate area of intersection of two bbox.
    Args:
    bbox1: first rectangle, [[x1, y1], [x2, y2]]
    bbox1: second rectangle, [[x1, y1], [x2, y2]]
    """
    xmin1 = min(bbox1[0][0], bbox1[1][0])
    xmin2 = min(bbox2[0][0], bbox2[1][0])
    xmini = max(xmin1, xmin2)

    ymin1 = min(bbox1[0][1], bbox1[1][1])
    ymin2 = min(bbox2[0][1], bbox2[1][1])
    ymini = max(ymin1, ymin2)

    xmax1 = max(bbox1[0][0], bbox1[1][0])
    xmax2 = max(bbox2[0][0], bbox2[1][0])
    xmaxi = min(xmax1, xmax2)

    ymax1 = max(bbox1[0][1], bbox1[1][1])
    ymax2 = max(bbox2[0][1], bbox2[1][1])
    ymaxi = min(ymax1, ymax2)

    w = xmaxi - xmini;
    h = ymaxi - ymini;
    if (w <= 0 or h <= 0):
        return 0.0
    return float(w * h)

def area(bbox):
    """Calculate area of bbox.
    Args:
    bbox: bbox, [[x1, y1], [x2, y2]]
    """
    w = abs(bbox[1][0] - bbox[0][0])
    h = abs(bbox[1][1] - bbox[0][1])
    return float(w * h)

def iou(bbox1, bbox2):
    i = inters_area(bbox1, bbox2)
    u = area(bbox1) + area(bbox2) - i
    if (u < 0.001):
        return 0.
    return i / u
