import os.path
os.environ['TF_CPP_MIN_LOG_LEVEL']='3'
import sys
import glob
import shutil

import json_ds_utils as jutils

def search(bad_urls_path, search_folder, image_folder):
    URL_SUFFIXES = {'image' : '_i', 'undistorted' : '_u'}

    with open(bad_urls_path) as f:
        bad_urls_list = f.read().splitlines()

    for url in bad_urls_list:
        feature_id, suffix = jutils.parse_image_url(url)
        assert (suffix in URL_SUFFIXES), 'Wrong URL format {} {}'.format(url, suffix)
        files = glob.glob('{}/**/{}.jpg'.format(search_folder, feature_id), recursive=True)
        if (len(files) == 0):
            print("There are not files corresponding url: {}".format(url))
        elif (len(files) == 1):
            shutil.copy(files[0], '{}/{}{}.jpg'.format(image_folder, feature_id, URL_SUFFIXES[suffix]))
        else:
            print("There are more than one file corresponding url: {}".format(url))
            for file in files:
                print("  {}".format(file))
            print()

if __name__ == '__main__':
    search(sys.argv[1], sys.argv[2], sys.argv[3])

