#!/bin/sh

echo $TF_RESEARCH_DIR"/object_detection/export_inference_graph.py"

if [ ! `echo :$PYTHONPATH: | grep -F :$TF_RESEARCH_DIR:` ]; then
    export PYTHONPATH=$PYTHONPATH:$TF_RESEARCH_DIR:$TF_RESEARCH_DIR/slim
fi

cuda_dev=$CUDA_VISIBLE_DEVICES
export CUDA_VISIBLE_DEVICES=-1

cur_dir=`pwd`
cd $1
base_folder=`pwd`
cd $cur_dir
train_dir=$base_folder"/train_folder/"
export_dir=$base_folder"/export_graphs/"

files=`ls $train_dir/model.ckpt-*.index`
for fn in $files
do
    fn=$(basename "$fn")
    ckpt_idx="${fn%.*}"
    ckpt_idx=${ckpt_idx#*-}
    #prefix is "model.ckpt-"
    echo $ckpt_idx
    graph_dir=$export_dir$ckpt_idx
    if [ ! -d "$graph_dir" ]; then
        python $TF_RESEARCH_DIR"/object_detection/export_inference_graph.py" --input_type=image_tensor --pipeline_config_path=$base_folder"/pipeline.config" --trained_checkpoint_prefix=$train_dir"model.ckpt-"$ckpt_idx --output_directory=$graph_dir
    fi
done

export CUDA_VISIBLE_DEVICES=$cuda_dev
