#!/bin/sh

if [ ! `echo :$PYTHONPATH: | grep -F :$TF_RESEARCH_DIR:` ]; then
    export PYTHONPATH=$PYTHONPATH:$TF_RESEARCH_DIR:$TF_RESEARCH_DIR/slim
fi

base_folder="$1"
tf_config_template="./faster_rcnn_resnet101_traffic_signs.template.config"
echo "Start preparing tfrecord..."
python ./code/make_ds_from_json.py $base_folder/setting.json ./images/ $base_folder $tf_config_template

python $TF_RESEARCH_DIR"/object_detection/train.py" --logtostderr --pipeline_config_path=$base_folder"/pipeline.config" --train_dir=$base_folder"/train_folder/"
