#include "tool.h"

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

#include <utility>

int main(int argc, char* argv[]) try {
    maps::cmdline::Parser parser;
    auto configPath = parser.string("config").help("path to configuration");
    auto inputDir
        = parser.string("input-dir").required().help("input directory path");
    auto assignmentId = parser.num("assignment-id")
                            .required()
                            .help("assignment ID to upload");
    auto deviceId =
        parser.string("device-id").required().help("device ID to upload");
    parser.parse(argc, argv);
    auto cfg = maps::mrc::common::templateConfigFromCmdPath(configPath);
    maps::mrc::uploadAssignment(cfg, inputDir, assignmentId, deviceId);
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
