#include <maps/libs/common/include/exception.h>
#include <maps/libs/common/include/base64.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/cmdline/include/cmdline.h>
#include <yandex/maps/mrc/traffic_signs/signs.h>
#include <mapreduce/yt/interface/client.h>
#include <util/generic/serialized_enum.h>

#include <string>
#include <utility>
#include <vector>
#include <map>

namespace ts = maps::mrc::traffic_signs;
using namespace NEnumSerializationRuntime;

int main(int argc, const char** argv) try {
    NYT::Initialize(argc, argv);

    maps::cmdline::Parser parser("Uploads traffic signs type to type map by horizontal flip YT");

    auto outputTableName = parser.string("output")
        .required()
        .help("Output YT table name");

    parser.parse(argc, const_cast<char**>(argv));

    INFO() << "Connecting to yt::hahn";
    auto client = NYT::CreateClient("hahn");

    INFO() << "Opening table " << outputTableName;
    auto writer = client->CreateTableWriter<NYT::TNode>(outputTableName.c_str());

    const TMappedArrayView<ts::TrafficSign>& signs = GetEnumAllValues<ts::TrafficSign>();
    for(const auto& sign : signs) {
        const auto& sign_flipped = flipTrafficSignHorz(sign);
        if (ts::TrafficSign::Unknown == sign_flipped)
            continue;
        writer->AddRow(
            NYT::TNode()
            ("type", NYT::TNode(ts::toString(sign)))
            ("type_flipped", NYT::TNode(ts::toString(sign_flipped)))
        );
    }
    writer->Finish();
}
catch (const maps::Exception& e) {
    FATAL() << "Worker failed: " << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    FATAL() << "Worker failed: " << e.what();
    return EXIT_FAILURE;
}
