#include <maps/wikimap/mapspro/services/mrc/libs/config/include/config.h>
#include <maps/wikimap/mapspro/services/mrc/libs/ugc_event_logger/include/logger.h>
#include <maps/wikimap/mapspro/services/mrc/ugc_back/lib/configuration.h>

#include <maps/infra/yacare/include/tvm.h>
#include <maps/infra/yacare/include/yacare.h>
#include <maps/libs/auth/include/blackbox.h>
#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/config/include/config.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/mongo/include/init.h>
#include <maps/libs/sql_chemistry/include/exceptions.h>
#include <maps/tools/grinder/common/include/config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <chrono>

namespace {

void errorReporter(const yacare::Request&, yacare::Response& resp)
{
    try {
        throw;
    }
    catch (const maps::sql_chemistry::ObjectNotFound& e) {
        resp << (yacare::errors::NotFound() << e.what());
    }
    catch (const maps::sql_chemistry::EditConflict& e) {
        WARN() << "Detected edit conflict: " << e.what();
        resp << (yacare::errors::Conflict() << e.what());
    }
    catch (const yacare::Error& e) {
        resp << e;
    }
    catch (const maps::Exception& e) {
        resp.setStatus(yacare::HTTPStatus::InternalError);
        resp << e.what();
        ERROR() << e;
    }
    catch (const std::exception& e) {
        resp.setStatus(yacare::HTTPStatus::InternalError);
        resp << e.what();
        ERROR() << "Internal error: " << e.what();
    }
}

}  // anonymous namespace

using yacare::VirtualHost;

auto vhost = VirtualHost{
    VirtualHost::SLB{"core-nmaps-mrc-ugc-back"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.ru"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.az"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.by"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.co.il"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.com"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.com.am"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.com.ge"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.com.tr"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.ee"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.eu"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.fi"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.fr"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.kg"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.kz"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.lt"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.lv"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.md"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.pl"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.tj"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.tm"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.ua"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.maps.yandex.uz"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.ru"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.az"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.by"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.co.il"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.com"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.com.am"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.com.ge"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.com.tr"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.ee"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.eu"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.fi"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.fr"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.kg"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.kz"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.lt"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.lv"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.md"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.pl"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.tj"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.tm"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.ua"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.common.testing.maps.yandex.uz"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.ru"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.az"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.by"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.co.il"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.com"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.com.am"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.com.ge"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.com.tr"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.ee"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.eu"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.fi"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.fr"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.kg"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.kz"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.lt"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.lv"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.md"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.pl"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.tj"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.tm"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.ua"},
    VirtualHost::FQDN{"core-nmaps-mrc-ugc-back.crowdtest.maps.yandex.uz"},
};


// The service accesses to external database to process requests
static yacare::ThreadPool ycrPool("pool", yacare::ThreadPool::CPUCOUNT(20), 1024);


YCR_SET_DEFAULT(vhost, ycrPool);

YCR_MAIN(argc, argv)
try {
    auto parser = maps::cmdline::Parser{};
    auto configPath = parser.string("config").help("path to MRC configuration");
    auto secretVersion =
        parser.string("secret-version")
            .help("version for secrets from yav.yandex-team.ru");
    auto grinderConfigPath =
        parser.string("grinder-config").help("path to grinder configuration");
    auto ugcEventLogPath = parser.string("ugc-event-log")
        .help("path to ugc events log")
        .defaultValue("/var/log/yandex/maps/mrc/ugc_events/ugc_events.log");
    parser.parse(argc, argv);

    INFO() << "starting";
    maps::mongo::init();
    auto config =
        maps::mrc::common::templateConfigFromCmdPath(secretVersion, configPath);
    auto grinderConfig = grinderConfigPath.defined()
                             ? maps::grinder::Config{grinderConfigPath}
                             : maps::grinder::Config{};
    auto tvmtoolSettings = maps::auth::TvmtoolSettings();
    yacare::tvm::configureUserAuth(maps::auth::BlackboxApi(tvmtoolSettings));
    const std::chrono::seconds LOG_ROTATION_PERIOD(3600);
    maps::mrc::ugc_event_logger::Logger ugcEventLogger(ugcEventLogPath, LOG_ROTATION_PERIOD);

    maps::mrc::ugc_back::Configuration::swap(
        maps::mrc::ugc_back::makeConfiguration(
            config,
            grinderConfig,
            ugcEventLogger,
            std::chrono::seconds{60},
            tvmtoolSettings.makeTvmClient()));
    yacare::setErrorReporter(errorReporter);
    yacare::run();
    INFO() << "shutting down";
    return EXIT_SUCCESS;
}
catch (const maps::Exception& e) {
    ERROR() << e;
    return EXIT_FAILURE;
}
catch (const std::exception& e) {
    ERROR() << e.what();
    return EXIT_FAILURE;
}
