#pragma once

#include <maps/infra/yacare/include/params/tvm.h>
#include <maps/infra/yacare/include/yacare.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

YCR_QUERY_PARAM(id, maps::mrc::db::TId);
YCR_QUERY_PARAM(photo_id, maps::mrc::db::TId);
YCR_QUERY_PARAM(ride_id, maps::mrc::db::TId);
YCR_QUERY_PARAM(size_name, std::string);

inline std::optional<std::string> getTokenHeader()
{
    const auto& env = yacare::request().env();
    auto it = env.find("HTTP_X_YA_SYNC_TOKEN");
    if (it == env.end()) {
        return std::nullopt;
    }
    return it->second;
}

inline void setTokenHeader(const std::string& token)
{
    yacare::response().setHeader("X-Ya-Sync-Token", token);
}

YCR_QUERY_CUSTOM_PARAM((), token, std::string, YCR_DEFAULT(""))
{
    Y_UNUSED(request);
    if (auto token = getTokenHeader()) {
        dest = *token;
        INFO() << "token found in HTTP headers: " << dest;
        return true;
    }
    INFO() << "token is not present in HTTP headers";
    return false;
}
