#include "config.h"

#include <maps/libs/json/include/value.h>

#include <vector>
#include <string>

namespace maps {
namespace wiki {
namespace rdrproxy {

namespace {

const std::string PERMISSION_FIELD_NAME = "permission";
const std::string PARAMS_FIELD_NAME = "bypass-params";
const std::string SERVICE_TVM_ALIAS_FIELD_NAME = "service-tvm-alias";

LayerConfig parseLayerConfig(const json::Value& layerConfigJson)
{
    LayerConfig layerConfig;
    layerConfig.url = layerConfigJson["url"].as<std::string>();

    if (layerConfigJson.hasField(PERMISSION_FIELD_NAME)) {
        layerConfig.permission =
            layerConfigJson[PERMISSION_FIELD_NAME].as<std::string>();
    }

    if (layerConfigJson.hasField(PARAMS_FIELD_NAME)) {
        layerConfig.bypassParams =
            layerConfigJson[PARAMS_FIELD_NAME].as<std::vector<std::string>>();
    }

    if (layerConfigJson.hasField(SERVICE_TVM_ALIAS_FIELD_NAME)) {
        layerConfig.serviceTvmAlias =
            layerConfigJson[SERVICE_TVM_ALIAS_FIELD_NAME].as<std::string>();
    }
    return layerConfig;
}

} // namespace

LayersConfig loadConfig(const json::Value& configJson)
{
    LayersConfig result;
    const auto& layersConfigJson = configJson["layers"];

    for (const auto& layerName : layersConfigJson.fields()) {
        result[layerName] = parseLayerConfig(layersConfigJson[layerName]);
    }
    return result;
}

} // namespace rdrproxy
} // namespace wiki
} // namespace maps
