#pragma once

#include <maps/libs/http/include/http.h>
#include <maps/libs/json/include/value.h>


#include <optional>
#include <string>
#include <vector>
#include <unordered_map>

namespace maps {
namespace wiki {
namespace rdrproxy {

struct LayerConfig {
    http::URL url;
    std::optional<std::string> permission;
    std::optional<std::string> serviceTvmAlias;

    std::vector<std::string> bypassParams;
};

using LayersConfig = std::unordered_map<std::string, LayerConfig>;

LayersConfig loadConfig(const maps::json::Value& configJson);

} // namespace rdrproxy
} // namespace wiki
} // namespace maps
