#include "../lib/config.h"

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps {
namespace wiki {
namespace rdrproxy {
namespace tests {

Y_UNIT_TEST_SUITE(config) {

Y_UNIT_TEST(test_parsing) {
    const std::string CORRECT_CONFIG = R"(
{
    "layers": {
        "mapsfactory" : {
            "url": "http://factory-backend.tst.maps.yandex.net/renderer?test_param=test",
            "permission" : "owner",
            "bypass-params": [ "id", "x", "y", "z"],
            "service-tvm-alias": "test_service"

        }
    }
}
)";

    auto config = loadConfig(maps::json::Value::fromString(CORRECT_CONFIG));
    UNIT_ASSERT_EQUAL(config.count("mapsfactory"), 1);
    const auto& mc = config["mapsfactory"];
    UNIT_ASSERT_EQUAL(mc.url.host(), "factory-backend.tst.maps.yandex.net");
    UNIT_ASSERT_EQUAL(mc.url.params(), "test_param=test");
    const std::vector<std::string> PARAMS_EXPECTED{
        "id", "x", "y", "z"
    };

    UNIT_ASSERT_EQUAL(mc.bypassParams, PARAMS_EXPECTED);
    UNIT_ASSERT_EQUAL(mc.serviceTvmAlias, "test_service");
}

} // Y_UNIT_TEST_SUITE

} // namespace tests
} // namespace rdrproxy
} // namespace wiki
} // namespace maps
