#pragma once

#include <cstdint>
#include <string>
#include <unordered_set>
#include <ostream>

namespace {
const size_t THREADS = 12;
} // namespace

namespace maps {
namespace wiki {
namespace renderer {

typedef int64_t TBranchId;
typedef int64_t TIndoorPlanId;
typedef unsigned int LayerId;
typedef std::unordered_set<LayerId> LayerIds;

const size_t CACHE_SIZE_DEFAULT = 1000;
const size_t CACHE_TIME_DEFAULT = 600; // seconds, 10 minutes
const size_t MUTEXES_SIZE_DEFAULT = 131;
const size_t DEFAULT_OBJECTS_QUANTITY_LIMIT = 100000;

enum class Scope { Objects, Labels, All };

inline std::string toString(Scope scope)
{
    return scope == Scope::Objects
        ? "objects"
        : scope == Scope::Labels ? "labels" : "all";
}

inline std::ostream& operator << (std::ostream& os, Scope scope)
{
    os << toString(scope);
    return os;
}

const std::string URL = "url";
const std::string TIMEOUT = "timeout";
const std::string CACHE_TIME = "cacheTime";
const std::string CACHE_SIZE = "cacheSize";
const std::string MUTEXES_SIZE = "mutexesSize";

} // namespace renderer
} // namespace wiki
} // namespace maps
