#pragma once

#include <maps/libs/xml/include/xml.h>
#include <filesystem>
#include <string>
#include <memory>
#include <map>

namespace maps {
namespace wiki {
namespace renderer {

/**
 * parametres from config
 */
class Config
{
public:

    struct Layer
    {
        std::string name;
        std::filesystem::path path;
    };
    typedef std::map<std::string, Layer> Layers;

    explicit Config(const std::string& filename);

    const Layers& layers() const { return layers_; }
    const std::string& defaultLayerName() const { return defaultLayerName_; }
    const std::string& layersPath() const { return layersPath_; }

private:
    Layers layers_;
    std::string defaultLayerName_;
    std::string layersPath_;
};

}}}//namespaces
