#pragma once

#include <maps/renderer/libs/base/include/zoom_range.h>
#include <maps/renderer/libs/geos_geometry/include/common.h>
#include <maps/renderer/libs/feature/include/yandex/maps/renderer/feature/feature_type.h>
#include <maps/libs/ymapsdf/include/ft.h>

namespace maps::wiki::renderer {

struct InputMarking {
    maps::renderer::geos_geometry::GeometryHolder geom;
    ymapsdf::ft::Type ftTypeId;
    std::optional<int> yaw; // in degree
};

struct OutputMarking {
    maps::renderer::geos_geometry::GeometryHolder geom;
    std::unordered_map<std::string, std::string> attrs;
};

using Markings = std::vector<OutputMarking>;

Markings generate(InputMarking&& input, maps::renderer::base::Zoom zoom);

} // namespace maps::wiki::renderer
