#pragma once

#include <maps/wikimap/mapspro/services/renderer/src/data_sets/include/source_layer.h>
#include <maps/renderer/libs/data_sets/data_set/include/data_set.h>
#include <maps/renderer/libs/data_sets/data_set/include/view_queriable.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <pqxx/transaction_base>

namespace YAML {
class Node;
} // namespace YAML

namespace maps::wiki::renderer {

constexpr auto SUBLAYERS = "sublayers";
constexpr auto INDOOR_LEVEL_ID = "indoor_level_id";
constexpr auto FILTER_PLACEHOLDER = "%FILTER%";
constexpr auto LAYERS_PLACEHOLDER = "%LAYERS%";
constexpr auto ZOOM_PLACEHOLDER = "%Z%";

struct AuxData
{
    std::string searchPath;
    std::function<pgpool3::TransactionHandle()> getTransaction;
    std::function<std::string(const std::string&)> getFilter;
    // allows to limit objects count in query in order to survive
    // very large numbers of objects in terms of both memory and time spent.
    // we don't provide full-featured batching since there will still be
    // the backend timeout problem
    std::optional<size_t> objectsQuantityLimit;
    mr::base::Vec2D shiftGeometry = {0.0, 0.0};
};

struct SubstitutionData
{
    using Substitutions = std::unordered_map<std::string, std::string>;

    std::unordered_map<std::string, Substitutions> sources;
    Substitutions global;
};

struct Source
{
    std::string id;
    std::unordered_set<std::string> mapTypes;
};
using Sources = std::unordered_map<std::string, Source>;


// Represents leaf of group layers tree: representation or layer without representations
//
struct SubLayer
{
    std::string id;
    std::string layerId;
    std::string groupId;
    std::string type;
    std::unordered_set<std::string> mapTypes;
    Sources sources;
};

class DataSet: public mr::data_set::DataSetBase,
               public mr::data_set::ViewQueriable
{
public:
    DataSet(const YAML::Node& layers, const YAML::Node& groups);

    // Implements mr::data_set::ViewQueriable
    std::vector<mr::data_set::LayerView> queryView(
        mr::data_set::ViewQueryContext& ctx) const override;

    const mr::data_set::DataSetInfo& info() const override;

    std::optional<std::string> schema() const override;

    ~DataSet();

private:
    std::vector<mr::data_set::LayerView>
    queryViewInternal(
        mr::data_set::ViewQueryContext& ctx,
        const SubstitutionData& substitutionData,
        const mr::data_set::ViewQueryParams::AcceptedLayers& result) const;

    SourceLayers sourceLayers_;
    mr::data_set::DataSetInfo info_;
    std::unordered_map<std::string, SubLayer> subLayers_;
    std::string schema_;
};

} // namespace maps::wiki::renderer
