#pragma once

#include <yandex/maps/renderer/feature/feature_type.h>
#include <maps/renderer/libs/data_sets/data_set/include/layer_info.h>
#include <maps/renderer/libs/data_sets/data_set/include/schema.h>

#include <string>
#include <vector>

namespace YAML {
class Node;
} // namespace YAML

namespace maps::wiki::renderer {

namespace mr = maps::renderer;

enum class FeatureGeneratorType
{
    RoadMarkingSymbol,
    RoadMarkingLine,
    RoadMarkingPolygon
};
DECLARE_ENUM_IO(FeatureGeneratorType);

class SourceLayer {
public:
    SourceLayer(std::string id,
                std::string table,
                mr::feature::FeatureType featureType);

    std::string id;
    std::string table;
    mr::feature::FeatureType featureType;
    uint32_t minzoom = 0;
    std::string geometryColumn = "geom";
    std::string geometryExpression = geometryColumn;
    std::string featureId = "id";
    std::optional<std::pair<std::string, std::string>> zoomRange;
    std::optional<std::string> zoomExpression;
    std::optional<std::pair<std::string, std::string>> zlevel;
    std::optional<std::string> filterClause;
    std::optional<std::string> selectionFilterClause1;
    std::optional<std::string> selectionFilterClause2;
    std::unordered_map<std::string, std::optional<std::string>> propertyExpressions;
    std::optional<FeatureGeneratorType> featureGenerator;

    mr::data_set::LayerInfo info;
    mr::data_set::schema::Layer schema;
};

using SourceLayers = std::unordered_map<std::string, SourceLayer>;
SourceLayers loadSourceLayers(const YAML::Node& layersNode);

} // maps::wiki::renderer
