#include <maps/wikimap/mapspro/services/renderer/src/data_sets/include/data_set.h>
#include <maps/wikimap/mapspro/libs/unittest/include/yandex/maps/wiki/unittest/arcadia.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/common/env.h>
#include <contrib/libs/yaml-cpp/include/yaml-cpp/yaml.h>

#include <filesystem>

namespace maps::wiki::tests {

namespace mr = maps::renderer;

Y_UNIT_TEST_SUITE(renderer_data_sets)
{

Y_UNIT_TEST_F(check_data_sets_queries, unittest::ArcadiaDbFixture)
{
    std::filesystem::path layersPath = std::string(
        ArcadiaSourceRoot() + "/maps/wikimap/mapspro/cfg/layers/v2");
    const auto groupsFileName = (layersPath / "groups.yaml").string();
    const auto layersFileName = (layersPath / "layers.yaml").string();

    YAML::Node groupsYaml = YAML::LoadFile(groupsFileName);
    YAML::Node layersYaml = YAML::LoadFile(layersFileName);

    auto datasetHolder = std::make_unique<maps::wiki::renderer::DataSet>(layersYaml, groupsYaml);

    std::vector<std::string> sublayers;
    for (const auto& groupNode: groupsYaml) {
        for (const auto& layerNode : groupNode["layers"]) {
            auto layerId = layerNode["id"].as<std::string>();
            auto presentationsNode = layerNode["presentations"];
            if (presentationsNode.IsDefined() && presentationsNode.size() > 0) {
                for (const auto& presentationNode : layerNode["presentations"]) {
                    auto id = presentationNode["id"].as<std::string>();
                    sublayers.push_back(id);
                }
            } else {
                sublayers.push_back(layerId);
            }
        }
    }

    maps::wiki::renderer::AuxData auxData;
    auxData.searchPath = "vrevisions_trunk,public";
    auxData.getTransaction = [&]() {
        auto connection = pool().getSlaveConnection("");
        return pgpool3::makeNonTransaction(std::move(connection));
    };
    auxData.objectsQuantityLimit = 100;

    mr::base::Zoom z = 21;
    mr::data_set::ViewQueryParams params{mr::base::BoxD{0, 0, 100, 100}, mr::base::ZoomRange{z, z}};
    params.auxData = auxData;

    mr::data_set::ViewQueryContext ctx(&params);

    for (const auto& sublayer: sublayers) {
        params.auxParams[maps::wiki::renderer::SUBLAYERS] = sublayer;
        std::vector<mr::data_set::LayerView> views;
        EXPECT_NO_THROW(views = datasetHolder->queryView(ctx)) << "sublayer id = '" << sublayer << "'";
        for (const auto& view: views) {
            auto iter = view.iterator();
            iter->hasNext();
        }
    }
}

}; // Y_UNIT_TEST_SUITE renderer_data_sets

} // namespace maps::wiki::tests
