#include <maps/wikimap/mapspro/services/renderer/src/data_sets/include/data_set.h>
#include <maps/libs/json/include/value.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/common/env.h>
#include <contrib/libs/yaml-cpp/include/yaml-cpp/yaml.h>

namespace maps::wiki::tests {

namespace mr = maps::renderer;
using namespace maps::wiki::renderer;

Y_UNIT_TEST_SUITE(data_set_schema_tests)
{

Y_UNIT_TEST(properties_test)
{
    const auto layersYaml = R"(
        - id: layer
          type: polyline
          table: objects_l_view

        - id: layer_with_properties
          type: polyline
          table: objects_l_view
          properties:
            - name: str
              expression: CAST(service_attrs->'srv:ft_type_id' as int)
            - name: str_with_values
              values:
                - value1
                - value2
            - name: num
              type: number
    )";
    const auto groupsYaml = "";

    auto layersNode = YAML::Load(layersYaml);
    auto groupsNode = YAML::Load(groupsYaml);

    auto dataset = DataSet(layersNode, groupsNode);

    auto schema = dataset.schema();
    EXPECT_TRUE(schema);

    auto schemaJson = json::Value::fromString(schema.value());
    EXPECT_TRUE(schemaJson.hasField("layers"));
    const auto& layersJson = schemaJson["layers"];
    {
        EXPECT_TRUE(layersJson.hasField("layer"));
        const auto& layer = layersJson["layer"];
        EXPECT_EQ(layer["geometryType"].as<std::string>(), "line");
        EXPECT_TRUE(layer.hasField("properties"));
        const auto& properties = layer["properties"];
        EXPECT_EQ(properties.size(), 1u);
        EXPECT_TRUE(properties.hasField("id"));
        {
            const auto& prop = properties["id"];
            EXPECT_EQ(prop["type"].as<std::string>(), "number");
        }
    }
    {
        EXPECT_TRUE(layersJson.hasField("layer_with_properties"));
        const auto& layer = layersJson["layer_with_properties"];
        EXPECT_EQ(layer["geometryType"].as<std::string>(), "line");
        EXPECT_TRUE(layer.hasField("properties"));
        const auto& properties = layer["properties"];
        EXPECT_EQ(properties.size(), 4u);
        EXPECT_TRUE(properties.hasField("id"));
        {
            const auto& prop = properties["id"];
            EXPECT_EQ(prop["type"].as<std::string>(), "number");
        }
        EXPECT_TRUE(properties.hasField("str"));
        {
            const auto& prop = properties["str"];
            EXPECT_EQ(prop["type"].as<std::string>(), "string");
            EXPECT_FALSE(prop.hasField("enum"));
        }
        EXPECT_TRUE(properties.hasField("str_with_values"));
        {
            const auto& prop = properties["str_with_values"];
            EXPECT_EQ(prop["type"].as<std::string>(), "string");
            EXPECT_TRUE(prop.hasField("enum"));
            const auto& values = prop["enum"];
            EXPECT_EQ(values.size(), 2u);
            EXPECT_EQ(values[0].as<std::string>(), "value1");
            EXPECT_EQ(values[1].as<std::string>(), "value2");
        }
        EXPECT_TRUE(properties.hasField("num"));
        {
            const auto& prop = properties["num"];
            EXPECT_EQ(prop["type"].as<std::string>(), "number");
            EXPECT_FALSE(prop.hasField("enum"));
        }
    }
}

Y_UNIT_TEST(generated_properties_test)
{
    const auto layersYaml = R"(
        - id: layer
          type: polyline
          table: objects_l_view

        - id: layer_with_road_marking_line_generator
          type: polyline
          feature_generator: road_marking_line
          table: objects_l_view
          properties:
            - name: ft_type_id
              type: number
              expression: CAST(service_attrs->'srv:ft_type_id' as int)

        - id: layer_with_road_marking_symbol_generator
          type: polygon
          feature_generator: road_marking_symbol
          table: objects_l_view
          properties:
            - name: ft_type_id
              type: number
              expression: CAST(service_attrs->'srv:ft_type_id' as int)
            - name: yaw
              type: number
              expression: CAST(domain_attrs->'road_marking:yaw' as int)

        - id: layer_with_road_marking_polygon_generator
          type: polygon
          feature_generator: road_marking_polygon
          table: objects_l_view
          properties:
            - name: ft_type_id
              type: number
              expression: CAST(service_attrs->'srv:ft_type_id' as int)
    )";
    const auto groupsYaml = "";

    auto layersNode = YAML::Load(layersYaml);
    auto groupsNode = YAML::Load(groupsYaml);

    auto dataset = DataSet(layersNode, groupsNode);

    auto schema = dataset.schema();
    EXPECT_TRUE(schema);

    auto schemaJson = json::Value::fromString(schema.value());
    EXPECT_TRUE(schemaJson.hasField("layers"));
    const auto& layersJson = schemaJson["layers"];
    {
        EXPECT_TRUE(layersJson.hasField("layer"));
        const auto& layer = layersJson["layer"];
        EXPECT_EQ(layer["geometryType"].as<std::string>(), "line");
        EXPECT_TRUE(layer.hasField("properties"));
        const auto& properties = layer["properties"];
        EXPECT_EQ(properties.size(), 1u);
        EXPECT_TRUE(properties.hasField("id"));
    }
    {
        EXPECT_TRUE(layersJson.hasField("layer_with_road_marking_line_generator"));
        const auto& layer = layersJson["layer_with_road_marking_line_generator"];
        EXPECT_EQ(layer["geometryType"].as<std::string>(), "line");
        EXPECT_TRUE(layer.hasField("properties"));
        const auto& properties = layer["properties"];
        EXPECT_EQ(properties.size(), 6u);
        EXPECT_TRUE(properties.hasField("id"));
        EXPECT_TRUE(properties.hasField("ft_type_id"));
        EXPECT_TRUE(properties.hasField("color"));
        EXPECT_TRUE(properties.hasField("dash"));
        EXPECT_TRUE(properties.hasField("width"));
        EXPECT_TRUE(properties.hasField("side"));
    }
    {
        EXPECT_TRUE(layersJson.hasField("layer_with_road_marking_symbol_generator"));
        const auto& layer = layersJson["layer_with_road_marking_symbol_generator"];
        EXPECT_EQ(layer["geometryType"].as<std::string>(), "area");
        EXPECT_TRUE(layer.hasField("properties"));
        const auto& properties = layer["properties"];
        EXPECT_EQ(properties.size(), 3u);
        EXPECT_TRUE(properties.hasField("id"));
        EXPECT_TRUE(properties.hasField("ft_type_id"));
        EXPECT_TRUE(properties.hasField("yaw"));
    }
    {
        EXPECT_TRUE(layersJson.hasField("layer_with_road_marking_polygon_generator"));
        const auto& layer = layersJson["layer_with_road_marking_polygon_generator"];
        EXPECT_EQ(layer["geometryType"].as<std::string>(), "area");
        EXPECT_TRUE(layer.hasField("properties"));
        const auto& properties = layer["properties"];
        EXPECT_EQ(properties.size(), 3u);
        EXPECT_TRUE(properties.hasField("id"));
        EXPECT_TRUE(properties.hasField("ft_type_id"));
        EXPECT_TRUE(properties.hasField("color"));
    }
}

}; // Y_UNIT_TEST_SUITE renderer_data_sets

} // namespace maps::wiki::tests
