#pragma once

#include "common.h"
#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/pgpool3utils/dynamic_pool_holder.h>
#include <maps/libs/xml/include/xml.h>
#include <string>
#include <memory>
#include <map>
#include <set>

namespace maps {
namespace wiki {
namespace renderer {

class DbWrapper
{
public:
    DbWrapper(const xml3::Nodes& nodes, const std::string& layerName);
    ~DbWrapper();

    bool isBranchAllowed(TBranchId branchId) const;

    std::set<Scope> allowedScopes(TBranchId branchId) const;

    maps::pgpool3::ConnectionHandle getConnection(
        const std::string& token, const TBranchId branchId, Scope scope);

private:
    bool isSplitDb() const;

    std::map<std::string, std::map<Scope, std::unique_ptr<pgp3utils::DynamicPoolHolder>>> alias2data_;
};

} // namespace renderer
} // namespace wiki
} // namespace maps
