#pragma once

#include <maps/libs/xml/include/xml.h>

#include <string>
#include <memory>


namespace maps {
namespace wiki {
namespace renderer {

class Filters
{
public:
    explicit Filters(const maps::xml3::Node& node);
    ~Filters();

    std::string filterClause(const std::string& id, const std::string& token) const;

private:
    std::string requestFilterClause(
            const std::string& id, const std::string& token) const;

    std::string url_;
    size_t timeout_;

    class Cache;
    std::unique_ptr<Cache> cache_;
};


}}}//namespaces
