#pragma once

#include "config.h"
#include "renderer.h"
#include "style2_renderer.h"

#include <string>

namespace maps::wiki::renderer {

class Global
{
public:
    explicit Global(const std::string& configFilename);
    ~Global();

    const Config& config() { return config_; }
    const Renderers& renderers() { return renderers_; }
    const Style2Renderers& style2Renderers() { return style2renderers_; }

private:
    const Config config_;
    Renderers renderers_;
    Style2Renderers style2renderers_;
};

class GlobalScope
{
public:
    GlobalScope(const std::string& modulePath, const std::string& configFilename);
    ~GlobalScope();

    static Global& instance();
};

} // maps::wiki::renderer
