#pragma once

#include "requestparams.h"

#include <yandex/maps/tilerenderer4/IOnlineRenderer.h>

#include <boost/shared_array.hpp>
#include <filesystem>
#include <memory>
#include <chrono>

namespace maps {
namespace wiki {

class ThreadPool;

namespace renderer {

typedef tilerenderer4::IOnlineRenderer TileRenderer;

class FreeTileRenderers;

class Renderer;
typedef std::shared_ptr<Renderer> RendererPtr;
typedef std::map<std::string, RendererPtr> Renderers;

class SearchPath;
class Filters;
class DbWrapper;

struct RenderedData
{
    RenderedData()
        : data(), size(0)
    {}

    RenderedData(boost::shared_array<char>&& data, size_t size)
        : data(std::move(data)), size(size)
    {}

    boost::shared_array<char> data;
    size_t size;
};


class Renderer
{
public:
    static Renderers create(
        const std::string& layerName, const std::filesystem::path& layerPath);

    ~Renderer();

    RenderedData render(const RequestParams& reqParams);

    std::chrono::seconds expires() const { return expires_; }

private:
    Renderer(const std::string& name, const std::filesystem::path& path);

    std::unique_ptr<TileRenderer> createTileRenderer() const;

    struct RenderParams;
    struct RenderResult;
    RenderResult renderInternal(const RenderParams& params);

private:
    std::unique_ptr<maps::wiki::ThreadPool> threadPool_;
    std::unique_ptr<FreeTileRenderers> freeTileRenderers_;
    std::unique_ptr<DbWrapper> dbWrapper_;

    std::string layerName_;
    std::string mapFilename_;

    bool transparent_;
    bool skipOutputCreation_;
    std::chrono::seconds expires_;
    std::unique_ptr<Filters> filters_;
    std::unique_ptr<SearchPath> searchPath_;
    std::optional<size_t> objectsQuantityLimit_;

    LayerIds textLayerIds_;
};


}}} //namespaces
