#include "searchpath.h"
#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace renderer {

SearchPath::SearchPath(const xml3::Node& node)
{
    if (node.isNull()) {
        return;
    }

    auto branchIdNode = node.node("branchId", true);
    if (!branchIdNode.isNull()) {
        formatByBranch_.parse(branchIdNode.value<std::string>());
    }
    defaultPath_ = node.attr<std::string>("default", "");
}

std::string
SearchPath::resolve(const TBranchId branchId) const
{
    if (branchId) {
        ASSERT(formatByBranch_.size());
        return str(boost::format(formatByBranch_) % branchId);
    }

    return defaultPath_;
}

}}} //namespaces
