#pragma once

#include "common.h"
#include "requestparams.h"
#include <maps/renderer/libs/font/include/loader.h>
#include <maps/renderer/libs/design/include/design.h>
#include <maps/renderer/libs/style2/include/style_set.h>
#include <maps/renderer/libs/style2_renderer/include/data_sets.h>
#include <maps/renderer/libs/style2_renderer/include/vec3_render_params.h>

#include <filesystem>
#include <unordered_map>
#include <memory>
#include <chrono>
#include <optional>

namespace maps::wiki::renderer {

class DbWrapper;
class SearchPath;
class Filters;
class Style2Renderer;
struct AuxData;
using Style2RendererPtr = std::shared_ptr<Style2Renderer>;
using Style2Renderers = std::unordered_map<std::string, Style2RendererPtr>;
using Vec3ResultFormat = maps::renderer::vecdata3::ResultFormat;

class Style2Renderer
{
public:
    static Style2Renderers create(
        const std::string& layerName,
        const std::filesystem::path& layersPath);

    Style2Renderer(
        const std::string& layerName,
        const std::filesystem::path& layersPath,
        const std::string& configFileName);

   ~Style2Renderer();

    std::vector<char> renderTile(
        const RequestParams& params) const;

    std::vector<char> renderVec3Tile(
        const RequestParams& params,
        Vec3ResultFormat format) const;

    std::string dataSetSchema() const;

    std::string indoorPlan(
        TIndoorPlanId planId,
        const TBranchId branchId,
        const std::string& token) const;

    std::chrono::seconds expires() const { return expires_; }

    void reloadDesign();

private:
    AuxData createAuxData(const RequestParams& params) const;

private:
    std::shared_ptr<maps::renderer::font::Loader> fonts_;
    maps::renderer::style2_renderer::DataSets datasets_;
    std::shared_ptr<maps::renderer::design::Design> design_;
    mutable std::mutex designMutex_;
    std::unique_ptr<maps::wiki::renderer::DbWrapper> dbWrapper_;
    std::unique_ptr<maps::wiki::renderer::Filters> filters_;
    std::unique_ptr<maps::wiki::renderer::SearchPath> searchPath_;
    std::string layerName_;
    std::filesystem::path layersPath_;
    std::chrono::seconds expires_;
    bool transparent_;
    std::optional<size_t> objectsQuantityLimit_;
};

} // namespace maps::wiki::renderer
