#pragma once

#include "common.h"
#include "filters.h"

#include <yandex/maps/tilerenderer4/IOnlineRenderer.h>

#include <string>
#include <set>
#include <stack>
#include <list>

namespace maps {
namespace wiki {
namespace renderer{

typedef std::vector<std::string> SubLayerParams;
typedef std::map<LayerId, SubLayerParams> ParsedSubLayers;

class SubLayersTraverse: public maps::tilerenderer4::ILayersTraverse
{
public:
    SubLayersTraverse(
        const ParsedSubLayers& parsedSubLayers,
        const std::string& token,
        maps::tilerenderer4::IOnlineRenderer& renderer,
        const Filters* filters);

    ~SubLayersTraverse() override;

    //! From ILayersTraverse
    bool onEnterGroupLayer(const maps::tilerenderer4::LayerInfo& layer) override;
    bool onVisitLayer(const maps::tilerenderer4::LayerInfo& layer) override;
    void onLeaveGroupLayer(const maps::tilerenderer4::LayerInfo& layer) override;
    bool isDone() override;

private:
    struct GroupLayerInfo
    {
        bool visible;
        boost::optional<std::string> filterClause;
        boost::optional<std::string> type;
    };

    enum class Mode { Set, Append };

    bool onVisitSelectionLayer(
            const maps::tilerenderer4::LayerInfo& layer,
            const SubLayerParams& subLayerParams);

    bool onVisitFilterLayer(
            const maps::tilerenderer4::LayerInfo& layer);

    bool onVisitIndoorLayer(
        const maps::tilerenderer4::LayerInfo& layer);

    void setFilterClause(
            LayerId layerId,
            std::string filterClause);

    void appendFilterClause(
            LayerId layerId,
            std::string filterClause);

private:

    enum class ProcessFilterClauseMode { Set, Append };

    void processFilterClause(
            LayerId layerId,
            std::string filterClause,
            ProcessFilterClauseMode mode);

    const ParsedSubLayers& requestedSubLayersToParams_;
    maps::tilerenderer4::IOnlineRenderer& renderer_;
    const Filters* filters_;
    const std::string& token_;

    std::stack<GroupLayerInfo> groupLayersStack_;
    std::list<renderer5::postgres::PfcParams> oldPfcParams_;
};


class TextLayersTraverse: public maps::tilerenderer4::ILayersTraverse
{
public:
    TextLayersTraverse();
    ~TextLayersTraverse() override;

    //! From ILayersTraverse
    bool onEnterGroupLayer(const maps::tilerenderer4::LayerInfo& layer) override;
    bool onVisitLayer(const maps::tilerenderer4::LayerInfo& layer) override;
    void onLeaveGroupLayer(const maps::tilerenderer4::LayerInfo& layer) override;
    bool isDone() override;

    const LayerIds& textGroupLayerIds() const { return textGroupLayerIds_; }

private:
    LayerIds textGroupLayerIds_;
    std::stack<bool> visibleGroupLayersStack_;
};


ParsedSubLayers parseSubLayers(const std::string& subLayers);

} //renderer
} //wiki
} //maps
