#pragma once

#include <string>

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>
#include <yandex/maps/wiki/threadutils/thread_pools.h>
#include <yandex/maps/wiki/revision/common.h>

namespace maps::wiki::renderer_overlay {

class Config
{
public:
    explicit Config(const std::string& filename, const std::string& servicesCfgFileName);

    const std::string& s3EndPoint() const
    { return s3EndPoint_; }

    const std::string& s3Bucket() const
    { return s3Bucket_; }

    const std::string& s3SourceImagesFolder() const
    { return s3SourceImagesFolder_; }

    const std::string& s3AccessKeyId() const
    { return s3AccessKeyId_; }

    const std::string& s3AccessKeySecret() const
    { return s3AccessKeySecret_; }

    const std::string& logLevel() const
    { return logLevel_; }

    pgpool3::Pool& aclPool() const { return aclPool_.pool(); }
    pgpool3::Pool& viewPool(revision::DBID branchId) const;

    ThreadPools& threadPools() const { return threadPools_; }

private:
    std::string s3EndPoint_;
    std::string s3Bucket_;
    std::string s3SourceImagesFolder_;
    std::string s3AccessKeyId_;
    std::string s3AccessKeySecret_;
    std::string logLevel_;
    const common::ExtendedXmlDoc servicesConfigXml_;
    mutable common::PoolHolder aclPool_;
    mutable common::PoolHolder viewTrunkPool_;
    mutable common::PoolHolder viewStablePool_;
    mutable ThreadPools threadPools_;
};

Config* cfg();

class ConfigScope
{
public:
    explicit ConfigScope(const std::string& filename, const std::string& servicesCfgFileName);
    ~ConfigScope();
};

}//namespaces maps::wiki::renderer_overlay
