#pragma once

#include <yandex/maps/imageutils2/fipimagewrapper.h>

namespace maps::wiki::renderer_overlay {

using PIXELCOLOR = std::uint32_t;//It's ARGB

class Image
{
public:
    Image(size_t x, size_t y);
    explicit Image(const std::string& data);

    size_t width() const;
    size_t height() const;
    void fitTo(size_t sizeLimit);

    PIXELCOLOR pixelColor(size_t x, size_t y) const;
    void setPixelColor(size_t x, size_t y, PIXELCOLOR color);
    std::string pngData() const;

private:
    maps::imageutils::FipImageWrapper image_;

};

} // namespace maps::wiki::renderer_overlay
