#pragma once

#include "config.h"
#include "transformation.h"
#include "image.h"

#include <maps/libs/tile/include/utils.h>
#include <maps/libs/json/include/value.h>

namespace maps::wiki::renderer_overlay {
struct OverlayImageInfo
{
    static OverlayImageInfo fromJson(json::Value value);
    std::string imageUuid;
    OverlayMethod method;
    size_t zOrder;
    std::vector<PixelMapping> mapping;
    std::shared_ptr<Image> image;
    std::unique_ptr<Transformation> transformation;
};

typedef std::multimap<size_t, OverlayImageInfo, std::greater<size_t>> OverlayImageInfoByZOrder;
OverlayImageInfoByZOrder readFromImagesArgByZOrder(
    const std::string& images,
    size_t zoom);
}
