#pragma once
#include <string>
#include <yandex/maps/wiki/common/lrucache.h>

namespace maps::wiki::renderer_overlay {
class Config;
class Image;

class Storage
{
public:
    explicit Storage(const Config&);

    std::string store(const Image& image);
    std::shared_ptr<Image> read(const std::string& dataId);

private:
    const Config& cfg_;
    common::LRUCacheThreadSafe<std::string, std::shared_ptr<Image>> dataIdToDataCache_;

};

Storage* storage();

class StorageScope
{
public:
    explicit StorageScope(const Config&);
    ~StorageScope();
};


} // namespace maps::wiki::renderer_overlay
