#include "transformation.h"

#include "transformation_polyorder0.h"
#include "transformation_polynomial.h"

#include <maps/libs/log8/include/log8.h>

using namespace maps::geolib3;

namespace maps::wiki::renderer_overlay {

constexpr enum_io::Representations<OverlayMethod> OVERLAY_METHOD_ENUM_REPRESENTATION {
    {OverlayMethod::POLYORDER0, "POLYORDER0"},
    {OverlayMethod::POLYORDER1, "POLYORDER1"},
    {OverlayMethod::POLYORDER2, "POLYORDER2"},
    {OverlayMethod::POLYORDER3, "POLYORDER3"},
};

DEFINE_ENUM_IO(OverlayMethod, OVERLAY_METHOD_ENUM_REPRESENTATION);


std::unique_ptr<Transformation>
createTransformation(
    size_t zoom,
    OverlayMethod method,
    const std::vector<PixelMapping>& mapping)
{
    try {
        switch (method) {
            case OverlayMethod::POLYORDER0:
                return std::make_unique<TransformationPOLYORDER0>(
                        TransformationPOLYORDER0(
                        zoom,
                        mapping));
            case OverlayMethod::POLYORDER1:
                return std::make_unique<TransformationPolynomial>(
                        zoom,
                        mapping,
                        1);
            case OverlayMethod::POLYORDER2:
                return std::make_unique<TransformationPolynomial>(
                        zoom,
                        mapping,
                        2);
            case OverlayMethod::POLYORDER3:
                return std::make_unique<TransformationPolynomial>(
                        zoom,
                        mapping,
                        3);
        }
    } catch (const std::exception& ex) {
        ERROR() << "Failed to create transformation: " << method
            << " with mapping points count: " << mapping.size();
    }
    return {};
}

} // namespace maps::wiki::renderer_overlay
