#pragma once

#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/tile/include/utils.h>

namespace maps::wiki::renderer_overlay {

enum class OverlayMethod
{
    POLYORDER0,
    POLYORDER1,
    POLYORDER2,
    POLYORDER3
};
DECLARE_ENUM_IO(OverlayMethod);

struct PixelMapping
{
    geolib3::Point2 mapCoord;
    geolib3::Point2 imageCoord;
};

class Transformation
{
public:
    virtual ~Transformation(){};

    virtual geolib3::Point2 toImageSpace(const geolib3::Point2& displayPoint) const = 0;
    virtual geolib3::Point2 toDisplayImage(const geolib3::Point2& imagePoint) const = 0;
};

std::unique_ptr<Transformation>
createTransformation(
    size_t zoom,
    OverlayMethod method,
    const std::vector<PixelMapping>& mapping);

} // namespace maps::wiki::renderer_overlay
