#include "transformation_polynomial.h"

#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/vector.h>
#include <maps/libs/tile/include/utils.h>

using namespace maps::geolib3;
using namespace maps::tile;
namespace {
constexpr double DETAIL_FACTOR = 0.001;
} // namespace

namespace maps::wiki::renderer_overlay {

TransformationPolynomial::TransformationPolynomial(
    size_t zoom,
    const std::vector<PixelMapping>& pointMappings,
    size_t order)
{
    ASSERT(pointMappings.size());
    const auto baseDisplayPointInt = mercatorToDisplaySigned(
        geoPoint2Mercator(pointMappings[0].mapCoord),
        zoom);
    baseDisplayPoint_ = Point2 {
            static_cast<double>(baseDisplayPointInt.x()),
            static_cast<double>(baseDisplayPointInt.y())};
    ControlPoints controlPoints;
    for (const auto& pointMapping : pointMappings) {
        Point2 pointOnMap = geoPoint2Mercator(pointMapping.mapCoord);
        auto pointOnMapDisplay = mercatorToDisplaySigned(pointOnMap, zoom);
        controlPoints.emplace_back(
            Point2(
                DETAIL_FACTOR * (pointOnMapDisplay.x() - baseDisplayPoint_.x()),
                DETAIL_FACTOR * (pointOnMapDisplay.y() - baseDisplayPoint_.y())),
            pointMapping.imageCoord
            );
    }
    transform_.reset(new PolynomialTransform2(controlPoints, order));
}

geolib3::Point2
TransformationPolynomial::toImageSpace(const geolib3::Point2& displayPoint) const
{
    geolib3::Point2 localDisplayPoint(
        DETAIL_FACTOR * (displayPoint.x() - baseDisplayPoint_.x()),
        DETAIL_FACTOR * (displayPoint.y() - baseDisplayPoint_.y()));
    return (*transform_)(localDisplayPoint, geolib3::TransformDirection::Forward);
}

geolib3::Point2
TransformationPolynomial::toDisplayImage(const geolib3::Point2& imagePoint) const
{
    const auto localDisplayPoint = (*transform_)(imagePoint, geolib3::TransformDirection::Backward);
    return {
        localDisplayPoint.x() / DETAIL_FACTOR + baseDisplayPoint_.x(),
        localDisplayPoint.y() / DETAIL_FACTOR + baseDisplayPoint_.y()
    } ;
}

} // namespace maps::wiki::renderer_overlay
