#pragma once
#include "transformation.h"

#include <maps/libs/geolib/include/transform.h>
#include <maps/libs/tile/include/utils.h>

namespace maps::wiki::renderer_overlay {

class TransformationPolynomial : public Transformation
{
public:
    TransformationPolynomial (
        size_t zoom,
        const std::vector<PixelMapping>& pointMappings,
        size_t order);

    geolib3::Point2 toImageSpace(const geolib3::Point2& displayPoint) const override;
    geolib3::Point2 toDisplayImage(const geolib3::Point2& imagePoint) const override;

private:
    std::unique_ptr<geolib3::PolynomialTransform2> transform_;
    geolib3::Point2 baseDisplayPoint_;
};

} // namespace maps::wiki::renderer_overlay
