#pragma once
#include "transformation.h"

#include <maps/libs/geolib/include/transform.h>

namespace maps::wiki::renderer_overlay {

class TransformationPOLYORDER0 : public Transformation
{
public:
    TransformationPOLYORDER0(
        size_t zoom,
        const std::vector<PixelMapping>& pointMappings);

    geolib3::Point2 toImageSpace(const geolib3::Point2& displayPoint) const override
    { return (*transform)(displayPoint, geolib3::TransformDirection::Forward);}
    geolib3::Point2 toDisplayImage(const geolib3::Point2& imagePoint) const override
    { return (*transform)(imagePoint, geolib3::TransformDirection::Backward);}

private:
    std::unique_ptr<geolib3::AffineTransform2> transform;
};

} // namespace maps::wiki::renderer_overlay
