#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <maps/wikimap/mapspro/services/renderer_overlay/lib/transformation_polynomial.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/transform.h>
#include <maps/libs/tile/include/utils.h>

#include <maps/libs/log8/include/log8.h>

using namespace maps::wiki::renderer_overlay;
using namespace maps::geolib3;
using namespace maps::tile;


Y_UNIT_TEST_SUITE(polynomial_order0)
{
Y_UNIT_TEST(polynomial_order3_11_points)
{
    const std::vector<PixelMapping> pointMappings = {
        {{37.58934984988942, 55.73418251412304}, {8, 9}},
        {{37.58918891734853, 55.73410079049734}, {4, 110}},
        {{37.589674397180225, 55.733669468515025}, {501, 197}},
        {{37.58945579714551, 55.73354839481758}, {501, 386}},
        {{37.59002710766568, 55.73327295075094}, {914, 344}},
        {{37.58980180210844, 55.7331306876664}, {936, 523}},
        {{37.5901746291615, 55.73337435071678}, {922, 195}},
        {{37.590426756808895, 55.73350753235956}, {924, 7}},
        {{37.58890594429747, 55.733581690121966}, {280, 587}},
        {{37.58944506830946, 55.73390253432092}, {246, 141}},
        {{37.58912136472399, 55.73344625309437}, {465, 588}},
    };
    const size_t zoom = 21;
    const TransformationPolynomial transfomator(zoom, pointMappings, 3);
    double rmse = 0;
    for (const auto& pt : pointMappings) {
        Point2 pointOnMap = geoPoint2Mercator(pt.mapCoord);
        const auto pointOnMapDisplay = mercatorToDisplaySigned(pointOnMap, zoom);
        const auto transformedSource = transfomator.toImageSpace(Point2(pointOnMapDisplay.x(), pointOnMapDisplay.y()));
        const auto& target = pt.imageCoord;
        rmse += (transformedSource.x() - target.x()) * (transformedSource.x() - target.x()) +
            (transformedSource.y() - target.y()) * (transformedSource.y() - target.y());
    }
    rmse =  sqrt(rmse)/pointMappings.size();
    UNIT_ASSERT(rmse < 1.0);
}
} // Y_UNIT_TEST_SUITE(test_polynomial_transfrom)
