#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/helpers.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/common.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/tasks_helpers.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/tasks_pins.h>

#include <maps/libs/tile/include/tile.h>
#include <maps/libs/tile/include/geometry.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/infra/yacare/include/params/tile.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/preset.h>

#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/social/feedback/task_filter.h>

#include <algorithm>

namespace maps::wiki::socialsrv {

namespace sf = social::feedback;
namespace mws = social;

namespace {

yacare::ThreadPool pinsThreadPool("pinsThreadPool", 10, 2048);

std::optional<size_t> getLimit(const tile::Zoom& zoom)
{
    constexpr tile::Zoom NO_LIMIT_ZOOM = 21u;
    constexpr size_t LIMIT_IN_PINS = 1000;

    if (zoom >= NO_LIMIT_ZOOM) {
        return std::nullopt;
    }
    return LIMIT_IN_PINS;
}

} // namespace

YCR_RESPOND_TO("PUT /feedback/tasks/pins", YCR_IN_POOL(pinsThreadPool),
    uid, token = "", tile)
{
    const auto bodyJson = json::Value::fromString(request.body());
    auto filter = makeTaskFilter(
        Globals::feedbackChecker(),
        uid,
        tile.z(),
        parseOptionalVector<sf::Type>(bodyJson["types"]),
        parseOptionalVector<sf::Workflow>(bodyJson["workflows"]),
        parseOptionalVector<std::string>(bodyJson["sources"]),
        parseOptional<bool>(bodyJson["hidden"]));

    Globals::feedbackChecker().fbPresetChecker().restrictFilterByGlobalPresets(filter, uid);

    addFilterParams(
        filter,
        Globals::aclChecker(),
        uid,
        tile,
        parseOptional<sf::UIFilterStatus>(bodyJson["status"]),
        parseOptionalVector<sf::AgeType>(bodyJson["ageTypes"]),
        parseOptional<std::string>(bodyJson["indoorLevel"]));

    filter.resolvedAt(parseOptionalDateTimeCondition(
        bodyJson["resolvedBefore"], bodyJson["resolvedAfter"]));
    filter.resolvedBy(parseOptional<acl::UID>(bodyJson["resolvedBy"]));
    filter.lastNeedInfoAt(parseOptionalDateTimeCondition(
        bodyJson["needInfoBefore"], bodyJson["needInfoAfter"]));
    filter.lastNeedInfoBy(parseOptional<acl::UID>(bodyJson["needInfoBy"]));

    auto socialTxn = Globals::dbPools().socialReadTxn(token);
    sf::GatewayRO gatewayRo(*socialTxn);

    auto result = gatewayRo.tasksBriefByFilter(filter, getLimit(tile.z()));

    makeJsonResponse(
        response,
        getPinsJsonString(result, uid, tile));
}

YCR_RESPOND_TO("GET /feedback/tasks/preset-pins", YCR_IN_POOL(pinsThreadPool),
    uid, token = "", tile)
{
    const auto presetId = queryParam<mws::TId>(request, "preset-id");
    const auto aoiId = queryParam<mws::TId>(request, "aoi-id");
    const auto indoorLevel = optionalQueryParam<std::string>(request, "indoor-level");
    const auto uiFilterStatus = optionalQueryParam<sf::UIFilterStatus>(request, "status");

    auto socialTxn = Globals::dbPools().socialReadTxn(token);

    auto preset = sf::getPreset(*socialTxn, presetId);
    SOCIAL_REQUIRE(preset, PresetNotFound, "Preset not found");

    auto coreTxn = Globals::dbPools().coreReadTxn(token);
    SOCIAL_REQUIRE(Globals::feedbackChecker().fbPresetChecker()
            .hasModifyPermission(uid, *preset, aoiId),
        Forbidden, "User has no permission for preset in this region");

    auto filter = makeTaskFilter(
        Globals::aclChecker(),
        uid,
        tile,
        *preset,
        aoiId,
        indoorLevel,
        uiFilterStatus);

    sf::GatewayRO gatewayRo(*socialTxn);
    auto result = gatewayRo.tasksBriefByFilter(filter, getLimit(tile.z()));

    makeJsonResponse(
        response,
        getPinsJsonString(result, uid, tile));
}

} // namespace maps::wiki::socialsrv
