#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/helpers.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/presets.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/tasks_helpers.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/serialize.h>

namespace maps::wiki::socialsrv {

namespace sf = social::feedback;

namespace {

const std::string MODIFY_PRESET_PERMISSION = "mpro/social/feedback/preset/modify";
const std::string READ_PRESET_PERMISSION = "mpro/social/feedback/preset/read";

yacare::ThreadPool feedbackPresetsThreadPool("feedbackPresetsThreadPool", 1, 1024);

} // unnamed namespace

YCR_USE(feedbackPresetsThreadPool) {

YCR_RESPOND_TO("GET /feedback/presets", uid, token = "")
{
    Globals::aclChecker().checkPermission(uid, READ_PRESET_PERMISSION);

    auto socialTxn = Globals::dbPools().socialReadTxn(token);
    auto presets = sf::getPresets(*socialTxn);

    makeJsonResponse(response, toJson(presets));
}

YCR_RESPOND_TO("GET /feedback/presets/assigned", uid, token = "")
{
    auto socialTxn = Globals::dbPools().socialReadTxn(token);
    auto coreTxn = Globals::dbPools().coreReadTxn(token);

    auto presetsAssigned = getAssignedPresetsResponse(
        *coreTxn, *socialTxn,
        Globals::feedbackChecker().fbPresetChecker(), uid);

    makeJsonResponse(response, toJson(presetsAssigned));
}

YCR_RESPOND_TO("GET /feedback/presets/tasks-feed", uid, token = "")
{
    const auto presetId = queryParam<social::TId>(request, "preset-id");
    const auto aoiId = queryParam<social::TId>(request, "aoi-id");
    const auto feedParams = getFeedParams(request);

    auto socialTxn = Globals::dbPools().socialReadTxn(token);

    auto feedForUI = getPresetsTasksFeed(
        *socialTxn,
        Globals::feedbackChecker(),
        uid,
        presetId,
        aoiId,
        feedParams);
    makeJsonResponse(response, toJson(feedForUI, uid));
}

YCR_RESPOND_TO("POST /feedback/presets", uid)
{
    Globals::aclChecker().checkPermission(uid, MODIFY_PRESET_PERMISSION);

    auto jsonBody = json::Value::fromString(request.body());
    makeJsonResponse(response, createPreset(jsonBody, Globals::dbPools().writeContext()));
}

YCR_RESPOND_TO("POST /feedback/presets/$", uid)
{
    Globals::aclChecker().checkPermission(uid, MODIFY_PRESET_PERMISSION);

    auto presetId = positionalParam<uint64_t>(argv, 0);
    auto jsonBody = json::Value::fromString(request.body());

    makeJsonResponse(response, updatePreset(presetId, jsonBody, Globals::dbPools().writeContext()));
}

YCR_RESPOND_TO("DELETE /feedback/presets/$", uid)
{
    Globals::aclChecker().checkPermission(uid, MODIFY_PRESET_PERMISSION);

    auto presetId = positionalParam<uint64_t>(argv, 0);
    std::string token = deletePreset(presetId, Globals::dbPools().writeContext());

    makeJsonResponse(response, toJson(token));
}

} // YCR_USE

} // namespace maps::wiki::socialsrv
