#include <maps/wikimap/mapspro/services/social/src/libs/common/common.h>
#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/helpers.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback-actions/tasks_regions.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/user_processing_level.h>

#include <maps/wikimap/mapspro/services/social/src/libs/feedback/common.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/feed_for_ui.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/operations.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/regions.h>
#include <maps/wikimap/mapspro/services/social/src/libs/feedback/serialize.h>

#include <maps/libs/geolib/include/serialization.h>
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback.h>
#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/common/geom.h>
#include <yandex/maps/wiki/common/date_time.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>
#include <yandex/maps/wiki/social/feedback/task_aoi.h>

#include <chrono>
#include <future>

namespace maps::wiki::socialsrv {

namespace rf = revision::filters;
namespace sf = social::feedback;

namespace {

const std::string DASHBOARD_PERMISSION = "mpro/social/feedback/dashboard";
const std::string REGIONS_PERMISSION = "mpro/social/feedback/regions";

sf::TaskFilter
getCommonTaskFilter(const json::Value& jsonBody)
{
    sf::TaskFilter filter;
    filter.duplicateHeadId(std::nullopt);
    filter.hidden(parseOptional<bool>(jsonBody["hidden"]));
    filter.types(parseOptionalVector<sf::Type>(jsonBody["types"]));
    filter.workflows(parseOptionalVector<sf::Workflow>(jsonBody["workflows"]));
    filter.sources(parseOptionalVector<std::string>(jsonBody["sources"]));
    filter.ageTypes(parseOptionalVector<sf::AgeType>(jsonBody["ageTypes"]));

    return filter;
}

std::set<sf::Partition> getPartitions(const std::optional<sf::UIFilterStatus> uiFilterStatus)
{
    std::set<sf::Partition> partitions = {sf::Partition::OutgoingOpened};
    if (!uiFilterStatus) {
        partitions.insert(sf::Partition::OutgoingClosed);
    } else if (uiFilterStatus == sf::UIFilterStatus::Resolved) {
        partitions = {sf::Partition::OutgoingClosed};
    }
    return partitions;
}

yacare::ThreadPool heavyStatThreadPool("heavyStatThreadPool", 1, 5);
yacare::ThreadPool feedbackRegionsThreadPool("feedbackRegionsThreadPool", 1, 1024);

} // namespace anonymous

/* This handle is especially heavy, so we have to limit its usage. Otherwise several
   sequential 'regions-stat' requests on each instance of social server can lead to
   lack of database connections and service gonna be down.
   Hope, that this is temporary solution
 */
YCR_RESPOND_TO("PUT /feedback/tasks/regions-stat", YCR_IN_POOL(heavyStatThreadPool), uid, token = "")
{
    Globals::aclChecker().checkPermission(uid, DASHBOARD_PERMISSION);

    auto coreTxn = Globals::dbPools().coreReadTxn(token);
    auto socialHandleGetter = [&]() {
        return Globals::dbPools().socialReadTxn(token);
    };

    sf::AoiTaskFilter filter;
    const auto bodyJson = json::Value::fromString(request.body());
    filter.types(parseOptionalVector<sf::Type>(bodyJson["types"]));
    filter.workflows(parseOptionalVector<sf::Workflow>(bodyJson["workflows"]));
    filter.sources(parseOptionalVector<std::string>(bodyJson["sources"]));

    auto regionStatRows = getRegionsStat(*coreTxn, socialHandleGetter, filter);

    makeJsonResponse(response, toJson(regionStatRows, uid));
}



YCR_USE(feedbackRegionsThreadPool) {

YCR_RESPOND_TO("PUT /feedback/tasks/regions", uid, token = "")
{
    Globals::aclChecker().checkPermission(uid, REGIONS_PERMISSION);

    const auto bodyJson = json::Value::fromString(request.body());
    auto filter = getCommonTaskFilter(bodyJson);
    if (!Globals::aclChecker().userHasPermission(uid, INTERNAL_CONTENT_TASK_PERMISSION)) {
        filter.internalContent(false);
    }
    if (!Globals::aclChecker().userHasPermission(uid, PROCESSING_LVL1_PERMISSION)) {
        filter.processingLvls({{sf::ProcessingLvl::Level0}});
    }
    filter.bucket(sf::Bucket::Outgoing);
    Globals::feedbackChecker().fbPresetChecker().restrictFilterByGlobalPresets(filter, uid);

    auto coreTxn   = Globals::dbPools().coreReadTxn(token);
    auto socialTxn = Globals::dbPools().socialReadTxn(token);

    auto regionToTaskCounters = getRegionsCounters(*coreTxn, *socialTxn, uid, filter);

    makeJsonResponse(response, toJson(regionToTaskCounters));
}

YCR_RESPOND_TO("PUT /feedback/tasks/region-feed/$", uid, token = "")
{
    Globals::aclChecker().checkPermission(uid, REGIONS_PERMISSION);
    const auto bodyJson = json::Value::fromString(request.body());

    //
    // collect TaskFilter
    //
    auto filter = getCommonTaskFilter(bodyJson);

    if (!Globals::aclChecker().userHasPermission(uid, INTERNAL_CONTENT_TASK_PERMISSION)) {
        filter.internalContent(false);
    }
    if (!Globals::aclChecker().userHasPermission(uid, PROCESSING_LVL1_PERMISSION)) {
        filter.processingLvls({{sf::ProcessingLvl::Level0}});
    }
    if (!Globals::aclChecker().userHasPermission(uid, HIDDEN_TASK_PERMISSION)) {
        filter.hidden(false);
    }

    filter.types(parseOptionalVector<sf::Type>(bodyJson["types"]));

    auto status = parseOptional<sf::UIFilterStatus>(bodyJson["status"]);
    filter.uiFilterStatus(status);

    filter.resolvedAt(parseOptionalDateTimeCondition(
        bodyJson["resolvedBefore"], bodyJson["resolvedAfter"]));
    filter.lastNeedInfoAt(parseOptionalDateTimeCondition(
        bodyJson["needInfoBefore"], bodyJson["needInfoAfter"]));
    filter.resolvedBy(parseOptional<acl::UID>(bodyJson["resolvedBy"]));
    filter.verdict(parseOptional<sf::Verdict>(bodyJson["resolution"]));
    filter.lastNeedInfoBy(parseOptional<acl::UID>(bodyJson["needInfoBy"]));
    Globals::feedbackChecker().fbPresetChecker().restrictFilterByGlobalPresets(filter, uid);

    //
    // do request
    //
    auto socialTxn = Globals::dbPools().socialReadTxn(token);
    auto feedForUI = getRegionsFeed(
        *socialTxn,
        positionalParam<ID>(argv, 0),
        getPartitions(status),
        filter,
        getFeedParams(request),
        getSubstitutionStrategy(Globals::aclChecker(), uid));

    makeJsonResponse(response, toJson(feedForUI, uid));
}

} // YCR_USE

} // maps::wiki::socialsrv
