#pragma once

#include <maps/wikimap/mapspro/services/social/src/api/globals.h>
#include <maps/wikimap/mapspro/services/social/src/libs/yacare/error.h>
#include <maps/wikimap/mapspro/libs/controller/include/asyncbasecontroller.h>
#include <maps/wikimap/mapspro/libs/controller/include/async_control_support.h>
#include <maps/wikimap/mapspro/libs/controller/include/asynctaskcontext.h>

#include <memory>

namespace maps::wiki::socialsrv {

template <typename Controller>
class ControllerAsyncTaskContext : public controller::AsyncTaskContext {
public:
    typedef typename Controller::Request Request;

    ControllerAsyncTaskContext(
            taskutils::Task task,
            std::shared_ptr<Request> request)
        : AsyncTaskContext(task)
        , request_(request)
    {}

protected:
    void createWorker() override
    {
        auto worker = std::make_unique<Controller>(*request_, task().id());
        worker_.swap(worker);
    }

    std::string invokeWorker() override
    {
        auto result = (*worker_)();
        return std::move(result->resultJson);
    }

    controller::ExceptionInfo handleWorkerException() override
    {
        return handleException();
    }

    std::string formatResult(const controller::AsyncTaskResult& asyncTaskResult) const override
    {
        return asyncTaskResult.toJson();
    }

private:
    std::shared_ptr<Request> request_;
    std::unique_ptr<Controller> worker_;
};

template <typename Controller>
class ControllerAsync: public controller::AsyncBaseController
{
public:
    typedef typename Controller::Request Request;
    ControllerAsync(
            const Request& request,
            WaitPolicy waitPolicy = WaitPolicy::Timeout)
        : controller::AsyncBaseController(Controller::taskName(), waitPolicy, Globals::asyncTasksSupport())
        , request_(std::make_shared<Request>(request))
    {}
    const std::string& taskName() const override { return Controller::taskName(); }
    std::string printRequest() const override { return request_->dump(); }

protected:
    void createAndExecTask()
    {
        auto taskControlData = controller::asyncTaskControlData<Controller>(*request_);
        auto task = createTask(
            request_->userId(),
            taskControlData);
        ASSERT (taskControlData.empty() || task);
        DEBUG() << "ControllerAsync<" << taskName() << "> is recoverable: " << !taskControlData.empty();
        if (task) {
            execTaskContext(
                std::make_shared<ControllerAsyncTaskContext<Controller>>(
                    *task,
                    request_));
        }
    }
    void control() override
    {
        createAndExecTask();
    }

private:
    std::shared_ptr<Request> request_;
};

} // namespace maps::wiki::socialsrv
