#include "create_review.h"
#include "helpers.h"
#include <maps/wikimap/mapspro/services/social/src/api/globals.h>

namespace maps::wiki::socialsrv {
namespace {
const std::string TASK_NAME = "CreateReview";
} // namespace

CreateReview::CreateReview(
        const Request& request,
        taskutils::TaskID asyncTaskID)
    : controller::BaseController<CreateReview>(CreateReview::taskName(), asyncTaskID)
    , request_(request)
{ }

std::string CreateReview::Request::dump() const
{
    return
        "region-id: " + std::to_string(regionId) +
        " uid: " + std::to_string(uid);
}

void CreateReview::control()
{
    const auto uid = request_.uid;
    const auto regionId = request_.regionId;
    checkPermissionsToWorkWithReviews(uid, ReviewAccessMode::Edit);
    auto writeContext = Globals::dbPools().writeContext();
    auto& socialWriteTxn = writeContext.socialTxn();
    auto& coreReadTxn = writeContext.coreTxn();
    const auto region = getRegionData(coreReadTxn, regionId);
    mwsf::ReviewsGateway gw(socialWriteTxn);
    const auto review = gw.createReview(
        regionId,
        region.commitId,
        region.pedestrianUid,
        uid,
        region.polygon,
        Globals::feedbackReviewNewTasksOnly()
            ? mwsf::ReviewsGateway::CreationPolicy::NewTasks
            : mwsf::ReviewsGateway::CreationPolicy::AllTasks);
    const auto reviewExternData = getReviewExternData(review, coreReadTxn, socialWriteTxn);
    checkAccessToReviewContents(reviewExternData, uid);
    const auto token = writeContext.commit();
    result_->resultJson = toJson(review, token, uid, reviewExternData);
}

const std::string&
CreateReview::taskName()
{
    return TASK_NAME;
}

} // namespace maps::wiki::socialsrv
